/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class ReduceNoiseFilter
extends WholeImageFilter {
    private int smooth(int[] v) {
        int minindex = 0;
        int maxindex = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < 9; ++i2) {
            if (i2 == 4) continue;
            if (v[i2] < min) {
                min = v[i2];
                minindex = i2;
            }
            if (v[i2] <= max) continue;
            max = v[i2];
            maxindex = i2;
        }
        if (v[4] < min) {
            return v[minindex];
        }
        if (v[4] > max) {
            return v[maxindex];
        }
        return v[4];
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        int[] r = new int[9];
        int[] g2 = new int[9];
        int[] b2 = new int[9];
        int[] outPixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int k2 = 0;
                for (int dy = -1; dy <= 1; ++dy) {
                    int iy = y + dy;
                    if (0 > iy || iy >= height) continue;
                    int ioffset = iy * width;
                    for (int dx = -1; dx <= 1; ++dx) {
                        int ix = x + dx;
                        if (0 > ix || ix >= width) continue;
                        int rgb = inPixels[ioffset + ix];
                        r[k2] = rgb >> 16 & 0xFF;
                        g2[k2] = rgb >> 8 & 0xFF;
                        b2[k2] = rgb & 0xFF;
                        ++k2;
                    }
                }
                while (k2 < 9) {
                    b2[k2] = 0;
                    g2[k2] = 0;
                    r[k2] = 0;
                    ++k2;
                }
                outPixels[index] = inPixels[index] & 0xFF000000 | this.smooth(r) << 16 | this.smooth(g2) << 8 | this.smooth(b2);
                ++index;
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Blur/Smooth";
    }
}

